#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_BaseShipment : BaseTest 
	{

		private BOL.BaseShipment _tstShipment;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			this._tstShipment = new BOL.BaseShipment();
		}

		[Test]
		public void Ctor_Pass()
		{
			//We already created the object in Setup		
			Assert.IsTrue(this._tstShipment.ShipmentGuid == System.Guid.Empty);
			Assert.IsTrue(this._tstShipment.LastUpdateUser == Common.LogonUser.LogonUserName);
			Assert.IsTrue(this._tstShipment.InvoiceNumber.Length > 0);
			Assert.IsTrue(this._tstShipment.ShipmentDirection == true);
			Assert.IsTrue(this._tstShipment.LastUpdateDate == System.DateTime.MinValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drSrc = new DataTable().NewRow();

			DataRow drTrg = this._tstShipment.LoadDataRowFromThis(drSrc);
			
			Assert.IsNull(drTrg);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}
		
		[Test]
		public void InitializeShipmentTable_Pass()
		{
			System.Collections.ArrayList alTest = BOL.BaseShipment.InitializeShipmentTable(true);

			Assert.IsTrue(alTest.Count == 2);
			DataTable dtTest = (DataTable)alTest[0];

			Assert.AreEqual(dtTest.TableName, TABLES.Shipment.TableName);
			Assert.AreEqual(dtTest.Columns.Count, 9);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.Shipment.ShipmentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.Shipment.ShipmentDirection));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.Shipment.InvoiceNumber));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.Shipment.LocalSupplierGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.Shipment.DivisionCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.Shipment.LastUpdateUser));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.Shipment.RowVersion));

			dtTest = (DataTable)alTest[1];
			Assert.AreEqual(dtTest.TableName, TABLES.BloodUnitShipment.TableName);
			Assert.AreEqual(dtTest.Columns.Count, 9);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.BloodUnitShipmentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.BloodUnitGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.OutgoingShipmentGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.LoginBloodProductGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.LoginFullProductCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.LoginValues));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.LastUpdateUser));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.BloodUnitShipment.RowVersion));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeShipmentTable_Fail()
		{
		}

		[Test]
		public void ShipmentGuid_Pass()
		{
			System.Guid unitGuid = System.Guid.NewGuid();
			this._tstShipment.ShipmentGuid = unitGuid;

			Assert.IsTrue(this._tstShipment.ShipmentGuid == unitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ShipmentGuid_Fail()
		{
		}

		[Test]
		public void LocalSupplierGuid_Pass()
		{
			System.Guid unitGuid = System.Guid.NewGuid();
			this._tstShipment.LocalSupplierGuid = unitGuid;

			Assert.IsTrue(this._tstShipment.LocalSupplierGuid == unitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LocalSupplierGuid_Fail()
		{
		}

		[Test]
		public void InvoiceNumber_Pass()
		{
			string tstValue = new Random().Next(555555).ToString();
			this._tstShipment.InvoiceNumber = tstValue;

			Assert.IsTrue(this._tstShipment.InvoiceNumber == tstValue);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void InvoiceNumber_Fail()
		{
			this._tstShipment.InvoiceNumber = "".PadRight(15,'X');
		}

		[Test]
		public void ShipmentDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;
			this._tstShipment.ShipmentDate = tstValue;

			Assert.IsTrue(this._tstShipment.ShipmentDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ShipmentDate_Fail()
		{
		}

		[Test]
		public void ShipmentDirection_Pass()
		{
			bool tstValue = (!this._tstShipment.ShipmentDirection);
			this._tstShipment.ShipmentDirection = tstValue;

			Assert.IsTrue(this._tstShipment.ShipmentDirection == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ShipmentDirection_Fail()
		{
		}

		[Test]
		public void ShipmentTypeCode_Pass()
		{
			string tstValue = new Random().Next(1,9).ToString();
			this._tstShipment.ShipmentTypeCode = tstValue;

			Assert.IsTrue(this._tstShipment.ShipmentTypeCode == tstValue);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void ShipmentTypeCode_Fail()
		{
			this._tstShipment.ShipmentTypeCode = "12";
		}

		[Test]
		public void ShipmentTemperature_Pass()
		{
			short tstValue = (short)new Random().Next(1,99);
			this._tstShipment.ShipmentTemperature = tstValue;

			Assert.IsTrue(this._tstShipment.ShipmentTemperature == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ShipmentTemperature_Fail()
		{
		}

		[Test]
		public void DivisionCode_Pass()
		{
			string tstValue = "12345";
			this._tstShipment.DivisionCode = tstValue;

			Assert.IsTrue(this._tstShipment.DivisionCode == tstValue);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void DivisionCode_Fail()
		{
			this._tstShipment.DivisionCode = "".PadRight(6,'X');
		}

		[Test]
		public void LastUpdateDate_Pass()
		{
			DateTime tstValue = System.DateTime.Now;
			this._tstShipment.LastUpdateDate = tstValue;

			Assert.IsTrue(this._tstShipment.LastUpdateDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LastUpdateDate_Fail()
		{
		}
		
		[Test]
		public void LastUpdateUser_Pass()
		{
			this._tstShipment.LastUpdateUser = Common.LogonUser.LogonUserName;
			Assert.IsTrue(this._tstShipment.LastUpdateUser == Common.LogonUser.LogonUserName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void LastUpdateUser_Fail()
		{
			this._tstShipment.LastUpdateUser = "".PadRight(31,'X');
		}

		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = new Byte[8];
			this._tstShipment.RowVersion = tstValue;

			Assert.IsTrue(this._tstShipment.RowVersion == tstValue);
		}

		[Test]
		public void RowVersion_Fail()
		{
			this._tstShipment.RowVersion = null;
			Assert.IsNull(this._tstShipment.RowVersion);
		}

		[Test]
		public void ProductShipperGuid_Pass()
		{
			System.Guid productShipperGuid = System.Guid.NewGuid();
			this._tstShipment.ProductShipperGuid = productShipperGuid;

			Assert.IsTrue(this._tstShipment.ProductShipperGuid == productShipperGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ProductShipperGuid_Fail()
		{
		}
	}
}

#endif
